/* --------------------------------------------------------------
  Environment.js 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/


/* globals self, top */

'use strict';

/**
 * Add events for displaying an AJAX spinner.
 *
 * @private
 */
function _setupAjaxSpinner() {
	const $ajaxSpinner = $('.ajax-spinner');
	
	$ajaxSpinner.html($('#loading-spinner-template').html());
	
	$(document).ajaxStart(function() {
		$ajaxSpinner
			.css({display: 'table'})
			.fadeTo(400, 1, 'linear');
	});
	
	$(document).ajaxStop(function() {
		$ajaxSpinner.fadeTo(400, 0, 'linear', function() {
			$(this).hide();
		});
	});
}

/**
 * Add a global error handler for the app.
 *
 * @private
 */
function _setupErrorHandler() {
	window.onerror = function(msg, url, line, col, error) {
		// Hide the ajax spinner and display the error message.
		const $errorFrame = $('.error-frame');
		
		if (window.StyleEdit) {
			$errorFrame.find('.message')
				.text(StyleEdit.Language.translate('message_unexpected_error', 'style_edit'));
		} else {
			$errorFrame.find('.message')
				.text('Oops! An unexpected error occurred during StyleEdit initialization! Check the browser\'s '
					+ 'console for more information.');
		}
		
		$('.ajax-spinner').hide();
		
		$errorFrame
			.css({display: 'table'})
			.fadeTo(400, 1, 'linear');
		
		// Show/Hide other UI elements.
		$('.style-edit-modal').remove();
		$('.frame-toggle').hide();
		$('.disable-layer').fadeIn();
		
		// Log error in the console (even in production environment).
		console.error('[StyleEdit Error Handler]', msg, '(line: ' + line + ', col: ' + col + ')', error);
		
		return true; // Suppress error alerts for old IE versions.  
	};
}

export default {
	/**
	 * Check whether the user's browser is an Internet Explorer
	 */
	isInternetExplorer() {
		const ua = window.navigator.userAgent;
		return (ua.indexOf('MSIE ') > -1 || ua.indexOf('Trident/') > -1 || ua.indexOf('Edge/') > -1);
	},
	
	/**
	 * Setup StyleEdit Environment
	 *
	 * This method will setup general operations that affect StyleEdit during all of its
	 * execution lifetime.
	 */
	setup() {
		// Check if StyleEdit was called from within an iframe and redirect back to the appropriate
		// URL if this is the case. 
		if (top !== self) {
			top.location = self.location;
		}
		
		// Location origin polyfill. 
		if (!window.location.origin) {
			window.location.origin = window.location.protocol + "//" + window.location.hostname
				+ (window.location.port ? ':' + window.location.port: '');
		}
		
		// Setup things ...
		_setupAjaxSpinner();
		_setupErrorHandler();
	}
}
